<?php
/**
 * renderers
 * 
 * @package    theme_aigne
 * @copyright  2013-2020 Franc Pombal (www.aigne.com)
 * @license    http://www.gnu.org/copyleft/gpl.html _ GNU GPL v3 or later
 */
defined('MOODLE_INTERNAL') || die();

class theme_aigne_core_renderer extends core_renderer {
    /**
     * The standard tags that should be included in the <head> tag.
     *
     * @return string HTML fragment.
     */
    // Included meta tags changes, to beginning with SEO tools in Moodle sites
    public function standard_head_html() {
        global $CFG, $SITE, $SESSION, $PAGE;

        $hasmtkeywords = (!empty($PAGE->theme->settings->mtkeywords));
        $hasmtdescription = (!empty($PAGE->theme->settings->mtdescription));
        $hasoptionalmtag = (!empty($PAGE->theme->settings->optionalmtag));
        $hascustommtag = (!empty($PAGE->theme->settings->custommtag));
        $hasdublinmtag = (!empty($PAGE->theme->settings->dublinmtag));
        $sitens = $SITE->shortname;
        $sitenf = $SITE->fullname;
            $data = new stdClass;
            $data->sitename = $sitens; 

        // Before we output any content, we need to ensure that certain
        // page components are set up.

        // Blocks must be set up early as they may require javascript which
        // has to be included in the page header before output is created.  <- A partir de la versin 2.6.x
        foreach ($this->page->blocks->get_regions() as $region) {
            $this->page->blocks->ensure_content_created($region, $this);
        }
        $output = '';

        // Give plugins an opportunity to add any head elements. The callback
        // must always return a string containing valid html head content.        
        $pluginswithfunction = get_plugins_with_function('before_standard_html_head', 'lib.php');
        foreach ($pluginswithfunction as $plugins) {
            foreach ($plugins as $function) {
                $output .= $function();
            }
        }

        // Allow a url_rewrite plugin to setup any dynamic head content.
        if (isset($CFG->urlrewriteclass) && !isset($CFG->upgraderunning)) {
            $class = $CFG->urlrewriteclass;
            $output .= $class::html_head_setup();
        }

                       
        //$output .= '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />' . "\n";
        $output .= '<META http-equiv="Content-Type" content="' . $this->contenttype . '" />';
        $output .= '<META http-equiv="X-UA-Compatible" content="IE=edge" />';
        $output .= '<META http-equiv="Page-Exit" content="blendTrans(Duration=0.1)" />';
        $output .= '<META http-equiv="imagetoolbar" content="no" />';
        if (!$this->page->cacheable) {
            //$output .= '<meta http-equiv="pragma" content="no-cache" />' . "\n";
            $output .= '<META http-equiv="Cache-Control" content="no-cache" />';
            $output .= '<META http-equiv="expires" content="0" />';
        }
        // This is only set by the {@link redirect()} method
        $output .= $this->metarefreshtag;
                
        // Check if a periodic refresh delay has been set and make sure we arn't
        // already meta refreshing
        if ($this->metarefreshtag=='' && $this->page->periodicrefreshdelay!==null) {
            $output .= '<meta http-equiv="refresh" content="'.$this->page->periodicrefreshdelay.';url='.$this->page->url->out().'" />';
        }
        
        // IMPORTANT META TAGs
            $output .= '<META name="language" content="' . current_language() . '" />';
        if ($hasmtkeywords) {
            $output .= '<META name="keywords" content="moodle, ' . ($PAGE->theme->settings->mtkeywords) . '" />';
        } else {
            //$output .= '<meta name="keywords" content="moodle, ' . $this->page->title . '" />' . "\n";
            $output .= '<META name="keywords" content="moodle, ' . get_string('metakeywords','theme_aigne') . '" />';
        }
        if ($hasmtdescription) {
            $output .= '<META name="description" content="' . ($PAGE->theme->settings->mtdescription) . '" />';
        } else {
            $output .= '<META name="description" content="' . get_string('metadescription','theme_aigne',$data) . '" />';
        }
        // OPTIONAL META TAGs
        if ($hasoptionalmtag) {
            $output .= '<META name="copyright" content="' . $sitens . '  ' . gmdate("Y") . '" />';
            $output .= '<META name="author" content="' . $sitenf . ' & moodle community" />';
            $output .= '<META name="distribution" content="global" />';
            $output .= '<META name="revisit-after" content="31 Days" />';
            $output .= '<META name="robots" content="index,nofollow" />';
            $output .= '<META name="url" content="' . $CFG->wwwroot . '" />';
            $output .= '<META name="viewport" content="width=device-width, maximum-scale=1.0" />';
        }
        // Custom META TAGs
        if ($hascustommtag) {
            $output .= ($PAGE->theme->settings->custommtag);
        }
        // COMPATIBILITY WITH 'Dublin Core Metadata Initiative'
        if ($hasdublinmtag) {
            $output .= '<META name="dc.language" content="' . current_language() . '" />';
            $output .= '<META name="dc.description" content="' . get_string('metadescription','theme_aigne',$data) . '" />';
            $output .= '<META name="dc.publisher" content="' . $sitens . '  ' . gmdate("Y") . '" />';
        }

        // Set up help link popups for all links with the helptooltip class <- A partir de la versin 2.3.x
        $this->page->requires->js_init_call('M.util.help_popups.setup');

        // flow player embedding support
        // $this->page->requires->js_function_call('M.util.load_flowplayer');

        // Setup help icon overlays.  <- A partir de la versin 2.5.x
        //$this->page->requires->yui_module('moodle-core-popuphelp', 'M.core.init_popuphelp');
        //$this->page->requires->strings_for_js(array(
            //'morehelp',
            //'loadinghelp',
        //), 'moodle');

        //$this->page->requires->js_function_call('setTimeout', array('fix_column_widths()', 20));

        $focus = $this->page->focuscontrol;
        if (!empty($focus)) {
            if (preg_match("#forms\['([a-zA-Z0-9]+)'\].elements\['([a-zA-Z0-9]+)'\]#", $focus, $matches)) {
                // This is a horrifically bad way to handle focus but it is passed in
                // through messy formslib::moodleform
                $this->page->requires->js_function_call('old_onload_focus', array($matches[1], $matches[2]));
            } else if (strpos($focus, '.')!==false) {
                // Old style of focus, bad way to do it
                debugging('This code is using the old style focus event, Please update this code to focus on an element id or the moodleform focus method.', DEBUG_DEVELOPER);
                $this->page->requires->js_function_call('old_onload_focus', explode('.', $focus, 2));
            } else {
                // Focus element with given id
                $this->page->requires->js_function_call('focuscontrol', array($focus));
            }
        }        

        // Get the theme stylesheet - this has to be always first CSS, this loads also styles.css from all plugins;
        // any other custom CSS can not be overridden via themes and is highly discouraged
        $urls = $this->page->theme->css_urls($this->page);
        foreach ($urls as $url) {
            $this->page->requires->css_theme($url);
        }

        // Get the theme javascript head and footer
        if ($jsurl = $this->page->theme->javascript_url(true)) {
            $this->page->requires->js($jsurl, true);
        }
        if ($jsurl = $this->page->theme->javascript_url(false)) {
            $this->page->requires->js($jsurl);
        }

        // Get any HTML from the page_requirements_manager.
        $output .= $this->page->requires->get_head_code($this->page, $this);

        // List alternate versions.
        foreach ($this->page->alternateversions as $type => $alt) {
            $output .= html_writer::empty_tag('link', array('rel' => 'alternate',
                    'type' => $type, 'title' => $alt->title, 'href' => $alt->url));
        }

        // Add noindex tag if relevant page and setting applied.
        $allowindexing = isset($CFG->allowindexing) ? $CFG->allowindexing : 0;
        $loginpages = array('login-index', 'login-signup');
        if ($allowindexing == 2 || ($allowindexing == 0 && in_array($this->page->pagetype, $loginpages))) {
            if (!isset($CFG->additionalhtmlhead)) {
                $CFG->additionalhtmlhead = '';
            }
            $CFG->additionalhtmlhead .= '<meta name="robots" content="noindex" />';
        }

        if (!empty($CFG->additionalhtmlhead)) {
            $output .= "\n".$CFG->additionalhtmlhead;
        }

        if ($PAGE->pagelayout == 'frontpage') {
            $summary = s(strip_tags(format_text($SITE->summary, FORMAT_HTML)));
            if (!empty($summary)) {
                $output .= "<meta name=\"description\" content=\"$summary\" />\n";
            }
        }

        return $output;
    }

    /**
     * Renders a custom menu object (located in outputcomponents.php)
     *
     * The custom menu this method override the render_custom_menu function
     * in outputrenderers.php
     * @staticvar int $menucount
     * @param custom_menu $menu
     * @return string
     */
    protected function render_custom_menu(custom_menu $menu) {
        global $CFG,$PAGE;

        $langs = get_string_manager()->get_list_of_translations();
        $haslangmenu = $this->lang_menu() != '';

        if (!$menu->has_children()) {
            return '';
        }

        // Add a login or logout link
        $hasmenulogout = $PAGE->theme->settings->menulogout;
        if ($hasmenulogout) {
            if (isloggedin()) {
                $branchlabel = get_string('logout');
                $branchurl   = new moodle_url('/login/logout.php');
            } else {
                $branchlabel = get_string('login');
                $branchurl   = new moodle_url('/login/index.php');
            }
            $branch = $menu->add($branchlabel, $branchurl, $branchlabel, -1);
        }

        // Initialise this custom menu
        $content = html_writer::start_tag('ul', array('class'=>'dropdown dropdown-horizontal'));
        foreach ($menu->get_children() as $item) {
            $context = $item->export_for_template($this);
            $content .= $this->render_from_template('core/custom_menu_item', $context);
        }
        // Close the open tags
        $content .= html_writer::end_tag('ul');        

        return $content;
    }
    
}

/* END OF FILE */    