<?php
/**
 * Strings for component 'theme_aigne', language 'es'
 * 
 * @package    theme_aigne
 * @copyright  2007-2016 Franc Pombal (www.aigne.com)
 * @license    http: *www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/****************************************************************************/
/********************_FIRST SECTION_CUSTOMIZABLE STRINGS_********************/
/****************************************************************************/
/* ----- ----- ----- -> STRINGS DE LAS ETIQUETAS META ----- */
$string['metakeywords'] = 'aigne, formación, educación, enseñanza, pedagogía';
$string['metadescription'] = 'Bienvenido a {$a->sitename}.';
/* ----- ----- ----- -> STRINGS DE LOS CUADROS DE MENSAJE DE FRONTPAGE ----- */
$string['moreinfo'] = 'Más información... ';
/* Strings del banner superior */
$string['banner1txt'] = 'Escriba aquí el texto que desea que aparezca en el banner';
$string['banner1ttl'] = 'Escriba aquí el título del banner';
$string['banner1alt'] = 'Escriba aquí el texto alternativo de la imagen del banner';
/* Strings del mensaje estático */
$string['frontmsgtxt'] = 'Aquí puede introducir un mensaje de bienvenida<br />
Escriba en su editor HTML favorito, a continuación entre en el archivo del idioma /theme/aigne/lang/ xx /theme_aigne.php y péguelo en $string[frontmsgtxt])<br />
<strong>Puede darle el formato CSS que quiera en el archivo aigne_style.css</strong>';
$string['frontmsgttl'] = 'Escriba aquí el título del mensaje';
/* Strings de los cuadros de información */
$string['quadro1txt'] = '
<h2>Cuadros de texto:</h2>
Aquí puede introducir cualquier información<br />
Escriba un texto en su editor HTML favorito, a continuación entre en el archivo del idioma 
<MARQUEE>/theme/aigne/lang/ xx /theme_aigne.php</MARQUEE> y péguelo en $string[quadro1txt]<br />
<strong>Puede darle formato CSS en el archivo aigne_style.css</strong>';
$string['quadro1ttl'] = 'Escriba aquí el título del cuadro 1';
$string['quadro1alt'] = 'Escriba aquí el texto alternativo de la imagen del cuadro 1';
$string['quadro2txt'] = '
<h2>Cuadros de texto:</h2>
Aquí puede introducir cualquier información<br />
Escriba un texto en su editor HTML favorito, a continuación entre en el archivo del idioma 
<MARQUEE>/theme/aigne/lang/ xx /theme_aigne.php</MARQUEE> y péguelo en $string[quadro2txt]<br />
<strong>Puede darle el formato CSS que quiera en el archivo aigne_style.css</strong>';
$string['quadro2ttl'] = 'Escriba aquí el título del cuadro 2';
$string['quadro2alt'] = 'Escriba aquí el texto alternativo de la imagen del cuadro 2';
$string['quadro3txt'] = '
<h2>Cuadros de texto:</h2>
Aquí puede introducir cualquier información<br />
Escriba un texto en su editor HTML favorito, a continuación entre en el archivo del idioma 
<MARQUEE>/theme/aigne/lang/ xx /theme_aigne.php</MARQUEE> y péguelo en $string[quadro3txt]<br />
<strong>Puede darle el formato CSS que quiera en el archivo aigne_style.css</strong>';
$string['quadro3ttl'] = 'Escriba aquí el título del cuadro 3';
$string['quadro3alt'] = 'Escriba aquí el texto alternativo de la imagen del cuadro 3';
/* Strings del acordeón horizontal de información */
$string['aco5cap1'] = 'Pastenague _ Texto del fuelle 1';
$string['aco5cap2'] = 'Requin _ Texto del fuelle 2';
$string['aco5cap3'] = 'Pieuvre _ Texto del fuelle 3';
$string['aco5cap4'] = 'Poisson _ Texto del fuelle 4';
$string['aco5cap5'] = 'Bouteilles _ Texto del fuelle 5';
$string['aco5alt1'] = 'Escriba aquí el texto alternativo de la imagen del fuelle 1';
$string['aco5alt2'] = 'Escriba aquí el texto alternativo de la imagen del fuelle 2';
$string['aco5alt3'] = 'Escriba aquí el texto alternativo de la imagen del fuelle 3';
$string['aco5alt4'] = 'Escriba aquí el texto alternativo de la imagen del fuelle 4';
$string['aco5alt5'] = 'Escriba aquí el texto alternativo de la imagen del fuelle 5';
/* Strings del slider vertical de información */
$string['sli5cap1'] = 'Texto informativo 1';
$string['sli5cap2'] = 'Texto informativo 2';
$string['sli5cap3'] = 'Texto informativo 3';
$string['sli5cap4'] = 'Texto informativo 4';
$string['sli5cap5'] = 'Texto informativo 5';
$string['sli5alt1'] = 'Escriba aquí el texto alternativo de la imagen de la diapositiva 1';
$string['sli5alt2'] = 'Escriba aquí el texto alternativo de la imagen de la diapositiva 2';
$string['sli5alt3'] = 'Escriba aquí el texto alternativo de la imagen de la diapositiva 3';
$string['sli5alt4'] = 'Escriba aquí el texto alternativo de la imagen de la diapositiva 4';
$string['sli5alt5'] = 'Escriba aquí el texto alternativo de la imagen de la diapositiva 5';
/* Strings del acordeón aigne de información */
$string['acoacap1'] = 'Diseño arquitectónico';
$string['acoacap2'] = 'Píldoras formativas';
$string['acoacap3'] = 'Diseño gráfico';
$string['acoacap4'] = 'Formación personalizada';
$string['acoacap5'] = 'Idiomas';
$string['acoaalt1'] = 'Escriba aquí el texto alternativo de la imagen del fuelle 1';
$string['acoaalt2'] = 'Escriba aquí el texto alternativo de la imagen del fuelle 2';
$string['acoaalt3'] = 'Escriba aquí el texto alternativo de la imagen del fuelle 3';
$string['acoaalt4'] = 'Escriba aquí el texto alternativo de la imagen del fuelle 4';
$string['acoaalt5'] = 'Escriba aquí el texto alternativo de la imagen del fuelle 5';
$string['acoainfo1'] = 'Escriba aquí la información que desea transmitir en el fuelle 1';
$string['acoainfo2'] = 'Escriba aquí la información que desea transmitir en el fuelle 2';
$string['acoainfo3'] = 'Escriba aquí la información que desea transmitir en el fuelle 3';
$string['acoainfo4'] = 'Escriba aquí la información que desea transmitir en el fuelle 4';
$string['acoainfo5'] = 'Escriba aquí la información que desea transmitir en el fuelle 5';
/**/
$string['newsinfo'] = 'Información académica';
$string['newsinfo1'] = '
<h2 style="text-align: center">Página de muestra 1</h2>
<p>&nbsp;</p>
<p>Aquí debe introducir toda la información interesante sobre su formación.</p>
<p>&nbsp;</p>';
$string['newsinfo2'] = '
<h2 style="text-align: center">Página de muestra 2</h2>
<p>&nbsp;</p>
<p>Aquí debe introducir toda la información interesante sobre su formación.</p>
<p>&nbsp;</p>';
$string['newsinfo3'] = '
<h2 style="text-align: center">Página de muestra 3</h2>
<p>&nbsp;</p>
<p>Aquí debe introducir toda la información interesante sobre su formación.</p>
<p>&nbsp;</p>';
$string['newsinfo4'] = '
<h2 style="text-align: center">Página de muestra 4</h2>
<p>&nbsp;</p>
<p>Aquí debe introducir toda la información interesante sobre su formación.</p>
<p>&nbsp;</p>';
$string['newsinfo5'] = '
<h2 style="text-align: center">Página de muestra 5</h2>
<p>&nbsp;</p>
<p>Aquí debe introducir toda la información interesante sobre su formación.</p>
<p>&nbsp;</p>';
/* ----- ----- ----- -> STRINGS DEL ENCABEZADO ----- */
$string['sloganaigne'] = '...añada un lema aquí...';
/* ----- ----- ----- -> SALUDOS Y MENSAJES DEL ÁREA DE INFORMACIÓN DEL USUARIO ----- */
/* Strings de saludos según la hora del día */
$string['general_greeting'] = 'Hola!';
$string['morning_greeting'] = 'Buenos días... !';
$string['afternoon_greeting'] = 'Buenas tardes... !';
$string['night_greeting'] = 'Buenas noches... !';
/* Strings de felicitación según la fecha */
$string['datemessage'] = 'Mensaje de felicitación';
$string['datemessage1'] = '¡¡¡Feliz año Nuevo!!!';
$string['datemessage2'] = '¡Disfruta del Carnaval!';
$string['datemessage3'] = '¡Buenas Pascuas, y disfruta de la Semana Santa!';
$string['datemessage4'] = '¡Disfruta del día de la Hispanidad!';
$string['datemessage5'] = 'Feliz Halloween y celebra el día de todos los Santos';
$string['datemessage6'] = '¡Feliz Navidad!';
$string['datemessage7'] = 'Disfruta del puente de ... ';
$string['datemessage8'] = '¡Qué disfrutes de las Vacaciones de Verano';
$string['datemessage9'] = '¡Qué disfrutes de las Vacaciones de Invierno';
/* ----- ----- ----- -> STRINGS DEL PIÉ DE PÁGINA ----- */
$string['contactlink'] = 'Contacte con nosotros: ';
$string['fisicallink'] = 'Visitános en nuestra dirección: ';
$string['sociallinks'] = '... y en las Redes Sociales: ';
$string['sendemailsubj'] = 'Información sobre {$a} ';
$string['sendemailtitle'] = '::: enviar un eMail al administrador del sitio web :::';
$string['powered'] = 'Con la potencia de: ';
$string['original_theme'] = 'Diseño inspirado en un tema original de Patrick Malley & Mary Evans';
$string['lastpageupdate'] = 'Esta página fue modificada por última vez en ';
$string['thanksvisit'] = 'Gracias por su confianza';
$string['reservedrights'] = 'Reservados todos los derechos';
/* ----- ----- ----- -> STTRINGS DE LA PROTECCIÓN DEL COPYRIGHT ----- */
$string['nocontentprint'] = '
<h2 style="text-align: center">Prevención de impresión</h2>
<h3><b>Copyright:</b></h3>
  <p>Todo el contenido de {$a->sitename} está amparado por la legislación vigente 
     que protege los derechos de autor. Si desea obtener más información, 
     visite nuestra página de {$a->disclaimer}.</p>
  <p>&nbsp;</p>
<h3><b>Impresión:</b></h3>
  <p>Para evitar posibles fraudes en la utilización del contenido de nuestros 
     cursos, se han instalado algunas herramientas básicas para prevenir la 
     impresión de ese contenido y proteger dichos derechos de autor.</p>
  <p>&nbsp;</p>
<h3><b>Obtener una copia:</b></h3>
  <p>Si usted está matriculado en alguno de nuestros cursos y necesita una 
     copia del contenido, que no esté incluida en el proprio curso, póngase en
     contacto con su Profesor o con el Administrador del Sitio para obtener 
     ayuda sobre el tema.</p>
  <p>&nbsp;</p>
<hr>
  <p style="text-align: center">Disculpe las molestias.</p>';
$string['nocontentdrag'] = 'Debido a la protección del copyright de nuestros cursos, esta deshabilitado arrastrar (drag & drop) algunos contenidos';
$string['nocontentselect'] = 'Debido a la protección del copyright de nuestros cursos, esta deshabilitado seleccionar (copy & paste) algunos contenidos';
/* ----- ----- ----- -> STRINGS DE LAS PÁGINAS DE AYUDA A LA NAVEGACIÓN ----- */
$string['navhelppage'] = 'Página de ayuda';
$string['navhelppagetitle'] = 'Ayuda a la navegación';
$string['webmap'] = 'mapa web';
$string['help'] = 'ayuda';
$string['footsearch'] = 'búsqueda';
$string['stats'] = 'estadísticas';
$string['disclaimer'] = 'aviso legal';
$string['policies'] = 'política del sitio';
$string['privacy'] = 'privacidad';
$string['security'] = 'seguridad';
$string['accessibility'] = 'accesibilidad';
$string['webmappage'] = '
<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<p>Aquí puede crear un mapa con la estructura de páginas que necesita
   para dar a conocer su organización, sus filosofía de trabajo y el 
   equipo humano que conforma su proyecto formativo.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->sitename}</ul>
<p>&nbsp;</p>';
$string['helppage'] = '
<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Ayuda a la navegación:</h2>
  <p>Aquí puede introducir todas las referencias necesarias para facilitar la 
     navegación por sus cursos. Además, puede crear una sección para enlazar con 
     el "Manual del alumnado" o manuales de utilización.</p>
<h2>Moodle:</h2>
  <p>Nuestra plataforma de enseñanza está basada en Moodle. Si desea ampliar 
     información sobre la usabilidad de Moodle, puede acceder a los 
     <a href="http://docs.moodle.org">documentos de ayuda oficiales</a>.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->link}</ul>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendemailtitle}</ul>
  <p>&nbsp;</p>';
$string['footsearchpage'] = '
<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Buscar:</h2>
  <p>Aquí puede introducir herramientas generales de búsqueda.</p>
  <p>&nbsp;</p>';
$string['statspage'] = '
<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Estadísticas:</h2>
  <p>Aquí puede introducir los resultados de estadísticas de navegación o 
     informes de avaliación de la formación dentro de su organización.</p>
  <p>&nbsp;</p>';
$string['disclaimerpage'] = '
<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Información legal:</h2>
<p> El presente documento regula la utilización de los sitios Web adscritos al dominio de Internet 
    "{$a->sitenamelow}.com"... o algo así.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->sitenamelow}</ul>
  <ul>{$a->sitename}</ul>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendemailtitle}</ul>
  <p>&nbsp;</p>';
$string['policiespage'] = '
<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Politicas del sitio:</h2>
  <p>Aquí puede introducir las políticas de uso del sitios web, los deberes y derechos 
     de los alumnos, .</p>
  <p>&nbsp;</p>';
$string['privacypage'] = '
<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Privacidad de los datos de usuario y alumnos</h2>
<p>Aquí puede introducir la información sobre la privacidad de los datos en la navegación 
   por el sitio web, además de las diferentes clausulas legales obligatorias.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->sitenamelow}</ul>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendemailtitle}</ul>
  <ul>{$a->remoteaddr}</ul>
  <ul>{$a->remotehost}</ul>
  <ul>{$a->remoteuser}</ul>
  <ul>{$a->language}</ul>
  <ul>{$a->useragent}</ul>
  <ul>{$a->referer}</ul>  
  <p>&nbsp;</p>';
$string['securitypage'] = '
<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Seguridad:</h2>
<p>Aquí puede introducir las medidas de seguridad que se utilizan para prevenir el SPAM, 
   la herramientas antivirus y los procedimientos de copia de seguridad.</p>
  <p>&nbsp;</p>';
$string['accessibilitypage'] = '
<h2 style="text-align: center">Esta es una página de muestra</h2>
<p>&nbsp;</p>
<h2>Accesibilidad</h2>
<p>Aquí puede introducir las herramientas que estan instaladas en el sitio web para 
   facilitar la navegación a personas con dificultades visuales o mobilidad reducida.</p>
<h2>Parámetros que se pasan:</h2>
  <ul>{$a->supportemail}</ul>
  <ul>{$a->sendemailtitle}</ul> 
  <p>&nbsp;</p>';
/****************************************************************************/
/********************_SECOND SECTION_CONFIGURATION STRINGS_******************/
/****************************************************************************/
$string['pluginname'] = 'aigne';
$string['configtitle'] = 'Configuración personalizada de aigne';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['notes'] = 'Notas del tema aigne';
$string['notesdesc'] = 'Para aplicar cualquier cambio en la configuración presione "Guardar cambios" al final de la página. Si no tiene habilitado el "Modo de diseño de temas", quizás necesite forzar la actualización entrando en Administración del sitio ► Desarrollo ►  <a href="purgecaches.php">"Purgar todas las Cachés"</a>.';
$string['noimplemented'] = 'Opción no implementada. Disculpe las molestías';
$string['sep_hr'] = '<hr>';
$string['sep_hr2'] = '<hr width="50%" align="center">';
$string['sep_br'] = '<br />';
$string['sep_bhr'] = '<br /><hr>';
/**/
$string['defaultfontsizetxt'] = 'Pulse para restaurar el tamaño de la fuente. (Recuperar el tamaño normal del diseño web)';
$string['decfontsizetxt'] = 'Pulse para disminuir el tamaño de la fuente. (Disminuir el tamaño del texto para mejorar la accesibilidad)';
$string['incfontsizetxt'] = 'Pulse para aumentar el tamaño de la fuente. (Aumentar el tamaño del texto para mejorar la accesibilidad)';
$string['defaultstyletxt'] = 'Pulse para recuperar el aspecto original del diseño web';
$string['styletxt'] = 'Pulse para aplicar una combinación de colores diferente al diseño web';
/**/
$string['generalhead'] = 'General';
$string['csshead'] = 'Opciones del diseño CSS';
$string['bodyfont'] = 'Tamaño de fuente';
$string['bodyfontdesc'] = 'Si lo desea puede configurar un tamaño de letra como referencia. Tenga cuidado con los tamaños de letra mas grandes o mas pequeños, ya que es sabido que causan problemas en algunos bloques, pruébelo y decida';
$string['fontfam'] = 'Familia de fuentes';
$string['fontfamdesc'] = 'Si lo desea puede modificar el aspecto del texto, cambiando la familia de fuente de referencia.';
$string['fontfam1'] = 'Eras Bk Bt';
$string['fontfam2'] = 'eras';
$string['fontfam3'] = 'afta';
$string['fontfam4'] = 'Arial';
$string['fontfam5'] = 'Tahoma';
$string['colorsch'] = 'Esquema de color del sitio.';
$string['colorschdesc'] = 'Seleccione el esquema de color que se usará de forma predeterminado. [::: en construcción :::] <br />
    <table class="headerop" Style="width: 325px; border: 2px solid #322C65;">
        <tr Style="height:25px">
            <td Style="background-color:#322C65">&nbsp;</td>
            <td Style="background-color:#007EBA">&nbsp;</td>
            <td Style="background-color:#CCDDEE">&nbsp;</td>
            <td Style="background-color:#F3F7FF">&nbsp;</td>
            <td Style="background-color:#FFFFFF">{$a->css_color1}</td>
            <td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="background-color:#001A1A">&nbsp;</td>
            <td Style="background-color:#004040">&nbsp;</td>
            <td Style="background-color:#4CA9BC">&nbsp;</td>
            <td Style="background-color:#F2FFEB">&nbsp;</td>
            <td Style="background-color:#FFFFFF">{$a->css_color2}</td>
            <td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="background-color:#522500">&nbsp;</td>
            <td Style="background-color:#EB8324">&nbsp;</td>
            <td Style="background-color:#F6CC87">&nbsp;</td>
            <td Style="background-color:#FFFFCC">&nbsp;</td>
            <td Style="background-color:#FFFFFF">{$a->css_color3}</td>
            <td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="background-color:#520000">&nbsp;</td>
            <td Style="background-color:#AA0000">&nbsp;</td>
            <td Style="background-color:#F1A78E">&nbsp;</td>
            <td Style="background-color:#FFF2F2">&nbsp;</td>
            <td Style="background-color:#FFFFFF">{$a->css_color4}</td>
            <td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="background-color:#520000">&nbsp;</td>
            <td Style="background-color:#AA0000">&nbsp;</td>
            <td Style="background-color:#F1A78E">&nbsp;</td>
            <td Style="background-color:#FFF2F2">&nbsp;</td>
            <td Style="background-color:#FFFFFF">{$a->css_color5}</td>
            <td Style="background-color:#FFFFFF; color:#3C3C3C">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="background-color:#222222">&nbsp;</td>
            <td Style="background-color:#666666">&nbsp;</td>
            <td Style="background-color:#AAAAAA">&nbsp;</td>
            <td Style="background-color:#F0F0F0">&nbsp;</td>
            <td Style="background-color:#FBFBFB">{$a->css_color6}</td>
            <td Style="background-color:#FFFFFF; color:#000000">A</td>
        </tr>
        <tr Style="height:25px">
            <td Style="width:25px; background-color:#F3F7FF">&nbsp;</td>
            <td Style="width:25px; background-color:#CCDDEE">&nbsp;</td>
            <td Style="width:25px; background-color:#322C65">&nbsp;</td>
            <td Style="width:25px; background-color:#000033">&nbsp;</td>
            <td Style="width:200px; background-color:#FFFFFF">{$a->css_color7}</td>
            <td Style="width:25px; background-color:#000033; color:#FFFFFF">A</td>
        </tr>
    </table>
';
$string['css_color1'] = 'Azul Claro';
$string['css_color2'] = 'Verde Musgo';
$string['css_color3'] = 'Naranja _ Primavera';
$string['css_color4'] = 'Rojo Rubí _ Verano';
$string['css_color5'] = 'Marrón _ Otoño';
$string['css_color6'] = 'Gris _ Invierno';
$string['css_color7'] = 'Azul Marino en contraste';
$string['backbody'] = 'Fondo de la página';
$string['backbodydesc'] = 'Si lo desea puede añadir una imagen que aparecerá en el fondo de la página.<br />
Debe ser una imagen JPG/PNG/GIF y según el tamaño, debe configurar la siguiente opción.';
$string['bgrepeat'] = 'Repetición de la imagen del fondo';
$string['bgrepeatdesc'] = 'Dependiendo del tipo de imagen, puede configurar su comportamiento, seleccionando si se repite, y en que dirección.';
$string['bgrepeat01'] = 'Imagen fija';
$string['bgrepeat02'] = 'Mosaico';
$string['bgrepeat03'] = 'Mosaico horizontal';
$string['bgrepeat04'] = 'Mosaico vertical';
$string['bgposition'] = 'Posición de la imagen del fondo';
$string['bgpositiondesc'] = 'Dependiendo del tipo de imagen, puede configurar el punto de origen de la imagen de fondo.';
$string['bgposition00'] = 'En el punto 0.0';
$string['bgposition01'] = 'Arriba';
$string['bgposition02'] = 'En el centro';
$string['bgposition03'] = 'Abajo';
$string['bgposition04'] = 'A la izquierda';
$string['bgposition05'] = 'A la derecha';
$string['bgposition06'] = 'Arriba a la izquierda';
$string['bgposition07'] = 'Arriba en el centro';
$string['bgposition08'] = 'Arriba a la derecha';
$string['bgposition09'] = 'En el centro a la izquierda';
$string['bgposition10'] = 'En el centro en el centro';
$string['bgposition11'] = 'En el centro a la derecha';
$string['bgposition12'] = 'Abajo a la izquierda';
$string['bgposition13'] = 'Abajo en el centro';
$string['bgposition14'] = 'Abajo a la derecha';
$string['bgposition15'] = 'En la mitad de la pantalla';
$string['backcolor'] = 'Color del fondo';
$string['backcolordesc'] = 'Si lo desea puede configurar un color de fondo, en lugar de imponer una imagen.<br />
Si desea mantener el color original, seleccione el blanco o escriba #FFFFFF.';
$string['aletters'] = 'Efecto de espaciado';
$string['alettersdesc'] = 'Cuando esta sobre un enlace, se puede ejecutar un efecto de espaciado entre las letras. 
Seleccione aquí ese hueco, y si a usted no le gusta el efecto, seleccione la primera opción. 
Tenga en cuenta que unos pocos enlaces no tienen ese efecto de forma predeterminada.';
$string['alettersno'] = 'Sin espaciado';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Cualquiera que sean las normas CSS que añada a esta caja de texto se reflejarán en todas las páginas, lo que facilita la personalización de este tema.';
/**/
$string['mtaghead'] = 'Opciones de las Etiquetas Meta';
$string['mtagheaddesc'] = 'Las Meta Etiquetas pueden ser utilizadas para mejorar el posicionamiento en algunos buscadores, así como ofrecer 
información fiable sobre nuestro sitio a multitud de servicios de indexación y clasificación que rondan por Internet.';
$string['mtkeywords'] = 'Meta Etiqueta Keywords';
$string['mtkeywordsdesc'] = 'Si lo desea puede escribir un contenido personalizado para la Meta Etiqueta "keywords".<br />
Por favor, tenga en cuenta el formato y el contenido, separando las palabras por coma y añadiendo un máximo de 25 palabras.<br />
Si deja en blanco esta opción, se generará una expresión automática con 5 palabras según el idioma';
$string['mtdescription'] = 'Meta Etiqueta Description';
$string['mtdescriptiondesc'] = 'Si lo desea puede escribir un contenido personalizado para la Meta Etiqueta "description".<br />
Por favor, tenga en cuenta el formato y el contenido, añadiendo un máximo de 250 caracteres<br />
Si deja en blanco esta opción, se generará una expresión de bienvenida según el idioma';
$string['optionalmtag'] = 'Meta Etiquetas Opcionales';
$string['optionalmtagdesc'] = 'Si activa esta opción, se generarán Meta Etiquetas adicionales, con información automática sobre su sitio.';
$string['custommtag'] = 'Meta Etiquetas Personales';
$string['custommtagdesc'] = 'Si desea personalizar al máximo, puede añadir aquí las Meta Etiquetas que necesita.<br />
Por favor, tenga en cuenta el formato y el contenido, escribiendo el código entero, como lo haría en un editor Web, siguiendo el siguiente ejemplo:<br />
<pre>
&lt;META name="distribution" content="global" /&gt;
&lt;META name="revisit-after" content="31 Days" /&gt;
&lt;META name="robots" content="index,nofollow" /&gt;
</pre>';
$string['dublinmtag'] = 'Meta Etiquetas Dublin Core ';
$string['dublinmtagdesc'] = 'Si activa esta opción, se generarán 3 etiquetas básicas (language, description, publisher) compatibles con el estándar "Dublin Core Metadata Initiative"';
/**/
$string['marketinghead'] = 'Opciones de la página principal del sitio (frontpage _ marketing)';
$string['marketingheaddesc'] = 'Esta sección se refiere a elementos que se mostrarán en la página principal del sitio, antes que el usuario se identifique ("entrar" _ "login") en la plataforma. 
Puede personalizar estas opciones a su gusto para añadir información sobre su institución o sobre el lanzamiento de nuevos cursos. <br />
Una vez activado, puede diseñar/programar el contenido que desee entrando directamente en el archivo del layout "frontinfo.php" y en la carpeta theme\aigne\pix\carroussel.';
$string['headbanner'] = 'Banner del Encabezado';
$string['headbannerdesc'] = 'Seleccione el tipo de información que desea que aparezca en la cabecera de la página principal.';
$string['infobanner'] = 'Zona de Información';
$string['infobannerdesc'] = 'Seleccione el tipo de información que desea que aparezca en la portada de su sitio Web.<br />';
$string['headerinfo'] = 'Imagen estática del banner';
$string['headerinfodesc'] = 'Si lo desea puede añadir una imagen fija en las zonas de información de la página principal.<br />
Debe ser una imagen JPG/PNG/GIF con un mínimo de 775px de largo y 100px de alto.';
$string['infobanner0'] = 'No mostrar ningún tipo de información';
$string['infobanner1'] = 'Mostrar un cuadro estático con un mensaje fijo';
$string['infobanner2'] = 'Mostrar una imagen estática';
$string['infobanner3'] = 'Mostrar tres cuadros estáticos con diferente contenido';
$string['infobanner4'] = 'Mostrar un cuadro informativo, tipo acordeón horizontal';
$string['infobanner5'] = 'Mostrar una presentación automática vertical de dispositivas';
$string['infobanner6'] = 'Mostrar una presentación automática horizontal de dispositivas';
$string['infobanner7'] = 'Mostrar formulario de entrada estándar';
$string['infobanner10'] = 'Mostrar el acordeón horizontal AIGNE';
/**/
$string['moodlehead'] = 'Opciones de personalización de elementos de Moodle';
$string['catstyle'] = 'Estilo de la lista de Categorias';
$string['catstyledesc'] = 'Elija el estilo que desea utilizar para las listas de Categorias.<br />
Recuerde que una vez utilice el estilo de "Parrilla de Imágenes", debe almacenar una imágen para cada categoria en la carpeta theme\aigne\pix\cat, siendo su nombre un número que corresponde al ID de dicha categoría.
Es recomendable utilizar una imágen no superior a 150px y de preferencia con el fondo transparente. Pruebe a voluntad con las imágenes de ejemplo.';
$string['catstyle1'] = 'Estilo estándar de Moodle';
$string['catstyle2'] = 'Estilo parrilla de imágenes';
$string['catstyle3'] = 'Estilo lista con iconos 32x32';
$string['contentcur'] = 'Solo contenido en los cursos';
$string['contentcurdesc'] = 'Si activa esta opción, solo se mostrará el contenido central en los cursos, sin los bloques laterales, para ganar espacio para el aprendizaje.';
$string['contentact'] = 'Solo contenido en las actividades';
$string['contentactdesc'] = 'Si activa esta opción, solo se mostrará el contenido central en las actividades, sin los bloques laterales, para ganar espacio para el aprendizaje';
$string['headactivity'] = 'Mostrar encabezado en las "Actividades"';
$string['headactivitydesc'] = 'En caso afirmativo, se mostrará un encabezado al principio de todas las Actividades de un curso (solo afecta a la versión 2.7.xx de moodle)';
$string['sitenewsi'] = 'Mostrar autor y opciones en las "Novedades"';
$string['sitenewsidesc'] = 'En caso afirmativo, se mostrará la información del autor y la línea de opciones en cada una de las "Novedades del Sitio" (Forum)';
/**/
$string['headerhead'] = 'Encabezado';
$string['logohead'] = 'Opciones del logotipo';
$string['logo'] = 'Logotipo';
$string['logodesc'] = 'Si lo desea puede añadir un logotipo personalizado.<br />
El logotipo debe ser una imagen JPG/PNG/GIF con 150px de largo y 55px de alto';
$string['slogan'] = 'Lema';
$string['slogandesc'] = 'Si lo desea puede añadir una pequeña frase que aparecerá bajo el logotipo, en forma de lema.<br />
Tenga en cuenta el tamaño de la frase para mantener el diseño del encabezado.';
$string['backlogo'] = 'Fondo del logotipo';
$string['backlogodesc'] = 'Si lo desea puede añadir una imagen de fondo para el logotipo.<br />
Debe ser una imagen JPG/PNG/GIF con 200px de largo y 75px de alto';
/**/
$string['custommenuhead'] = 'Opciones del menú personalizado';
$string['custommenudesc'] = 'Para diseñar un menú personalizado y añadir los ítems necesarios, entre en Administración del sitio ► Apariencia ► Temas ► <a href="settings.php?section=themesettings">"Ajustes de temas"</a> ►  "custommenuitems"  .<br />
A continuación puede configurar los dos colores principales, las demas opciones deben ser configuradas directamente en el archivo css (aigne_menu.css).';
$string['menucolor'] = 'Color del menú personalizado';
$string['menucolordesc'] = 'Seleccione el color de fondo del menú personalizado. Las demás opciones deben ser configuradas directamente en el archivos css (aigne_menu.css).';
$string['menucolorhl'] = 'Color de contraste del menú personalizado';
$string['menucolorhldesc'] = 'Seleccione el color de contraste del menú personalizado. Tenga en cuenta la combinación con el anterior color para mentener un diseño agradable';
$string['menulogout'] = 'Enlace para salir';
$string['menulogoutdesc'] = 'Si activa esta opción, aparecerá un enlace en el menú personalizado para salir/entrar en la plataforma.';
/**/
$string['breadcrumbhead'] = 'Opciones de la Barra de navegación';
$string['bcsep'] = 'Separador de la Barra de Navegación';
$string['bcsepdesc'] = 'Seleccione el tipo de separador que se debe usar en la Barra de Navegación.';
$string['bcsep1'] = 'Flecha convencional ( ► ) ';
$string['bcsep2'] = 'Comillas Latinas de cierre ( » ) ';
$string['bcsep3'] = 'Línea vertical ( | ) ';
$string['bcsep4'] = 'Barra inclinada ( / ) ';
$string['bcsep5'] = 'Guión bajo ( _ ) ';
$string['bcsep6'] = 'Varios dos puntos ( ::: ) ';
$string['bcsep7'] = 'Espacio en blanco ( &nbsp; ) ';
/**/
$string['usernavhead'] = 'Opciones del area de Información del Usuario';
$string['usernav'] = 'Area de Información del Usuario.';
$string['usernavdesc'] = 'Seleccione el modo que aparecerá la información del usuario, en el encabezado, en el bloque de navegación o sin información del usuario.
Tenga en cuenta, que la opción 2 (nuevo menú del usuario) solo funcionará a partir de la versión 2.8 de Moodle. ';
$string['useraigne'] = 'En el Encabezado, al estilo aigne (login + saludo + usuario + foto + logout)';
$string['usermenu'] = 'En el Encabezado, al estilo del nuevo menú del usuario (saludo + nuevo menú desplegable)';
$string['usermoodle'] = 'En el Encabezado, al estilo antiguo de moodle (login + saludo + usuario + logout)';
$string['usersalut'] = 'En el Encabezado, solo un saludo';
$string['usernone'] = 'Sin ningún tipo de información del usuario';
$string['usernavheaddesc'] = 'Las siguientes opciones configuran un saludo o mensage que aparecerá en el area de Información del Usuario.<br />
Si desea que además aparezca la casilla para recordar usuario, vaya a Administración del sitio ► Seguridad ► Políticas del sitio ► "rememberusername"';
$string['usernavsalut'] = 'Saludo';
$string['usernavsalutdesc'] = 'Si activa esta opción, aparecerá un saludo o un mensaje en el area de Información del Usuario.<br />
Si deja en blanco el mensaje de bienvenida y la felicitación, se mostrará un saludo relativo a la hora del día.<br />
Si desea mostrar un mensaje fijo, definálo en el mensaje de bienvenida.<br />
Si desea mostrar un mensaje dependiente de una fecha, defina el mensaje de felicitación e indique el inicio y el final para dicho periodo.<br />';
$string['welcomemsg'] = 'Mensaje de bienvenida';
$string['welcomemsgdesc'] = 'Defina un mensaje de bienvenida';
$string['datemessage'] = 'Mensaje especial';
$string['datemessagedesc'] = 'Defina el mensaje que desea mostrar durante un período de tiempo determinado<br />
Por ejemplo, puede poner un saludo para una época o festivo "Feliz Navidad...", <br />
indicar algún tipo de acontecimiento especial de la plataforma "Estamos inaugurando un nuevo diseño web..." <br />
o también puede anunciar un nuevo tipo de curso "Compruebe nuestros nuevos cursos de idiomas"<br />';
$string['datemessagestart'] = 'Fecha de inicio';
$string['datemessagefinis'] = 'Fecha de finalización';
$string['usernavinfo'] = 'Nombre del usuario';
$string['usernavinfodesc'] = 'Si activa esta opción, aparecerá el nombre del usuario en el area de Información del Usuario en el encabezado.';
$string['usernavpic'] = 'Foto del usuario';
$string['usernavpicdesc'] = 'Si activa esta opción, aparecerá una foto del usuario en el area de Información del Usuario en el encabezado.';
$string['usernavout'] = 'Botón de salida';
$string['usernavoutdesc'] = 'Si activa esta opción, aparecerá un botón de salida de la plataforma en el area de Información del Usuario en el encabezado.';
$string['outbutton'] = 'Opción de salir al estilo de botón';
$string['outmoodle'] = 'Opción de salir al estilo moodle, con un enlace';
$string['outnone'] = 'Sin la opción de salir';
/**/
$string['bottomphead'] = 'Pié de Página';
$string['navhelphead'] = 'Opciones de ayuda a la navegación';
$string['navhelp'] = 'Enlace de la ayuda a la navegación';
$string['navhelpdesc'] = 'Dirección de la página donde están configuradas las opciones de la barra de ayuda a la navegación';
$string['navhelplinks'] = 'Enlaces a mostrar';
$string['navhelplinksdesc'] = 'Seleccione los enlaces que desea mostrar en la barra de ayuda a la navegación del pié de página';
$string['moodledocsdesc'] = 'Enlace a los documentos de ayuda originales (MoodleDocs) en <a href="http://docs.moodle.org/" target="_blank">docs.moodle.org.</a>';
$string['helpdesc'] = 'Ayuda general de la plataforma';
$string['webmapdesc'] = 'Esquema de páginas de la plataforma, que formará el Mapa Web';
$string['footsearchdesc'] = 'Búsqueda general dentro de la plataforma';
$string['statsdesc'] = 'Estadísticas de uso de la plataforma';
$string['disclaimerdesc'] = 'Aviso legal obligatorio';
$string['policiesdesc'] = 'Política general de la plataforma';
$string['privacydesc'] = 'Información sobre la privacidad en la navegación dentro de la plataforma';
$string['securitydesc'] = 'Información sobre la seguridad en la navegación dentro de la plataforma';
$string['accessibilitydesc'] = 'Información sobre accesibilidad de la plataforma';
/**/
$string['contacthead'] = 'Opciones de contacto';
$string['corpweb'] = 'Dirección Web';
$string['corpwebdesc'] = 'Introduzca aquí la dirección web de su Organización, Institución educativa o Empresa matriz. (ej.: http://www.dominio_empresa.es/) <br />
Esta dirección no tiene relación con ruta indicada en config.php';
$string['emailimg'] = 'Imagen para eMail';
$string['emailimgdesc'] = 'Aquí puede añadir una imagen con la dirección eMail de soporte. Esto ayudará a prevenir que herramientas maliciosas de spam capturen su dirección eMail. <br />
Configure esta dirección eMail en Administración del sitio ► Servidor ► <a href="settings.php?section=supportcontact">"Contacto de soporte"</a> ► "supportemail" . 
Tenga en cuenta las proporciones en el diseño y añada una imagen de 32px de alto.';
$string['skype'] = 'Cuenta de Skype';
$string['skypedesc'] = 'Introduzca el nombre de usuario de su Organización / Institución educativa / Empresa matriz, en la red de Skype.';
$string['contactnote'] = 'Contacto';
$string['contactnotedesc'] = 'Aquí puede añadir información de contacto que aparecerá en medio de la zona de contacto del pié de página';
$string['maplink'] = 'Enlace al Mapa';
$string['maplinkdesc'] = 'Introduzca la dirección web del mapa con la ubicación de su organización. Puede usar servicios como "google maps", "bing maps", ...';
/**/
$string['socialcontenthead'] = 'Opciones de enlaces a las webs donde comparte contenido o amplia información sobre su institución';
$string['dropbox'] = 'Enlace a DropBox';
$string['dropboxdesc'] = 'Introduzca el enlace (URL) a su cuenta en DropBox.
<a href="http://www.dropbox.com/" target="_blank"> (www.dropbox.com) .</a>';
/**/
$string['dayviews'] = 'Enlace a DayViews';
$string['dayviewsdesc'] = 'Introduzca el enlace (URL) a su página en DayViews.
<a href="http://dayviews.com/" target="_blank"> (dayviews.com) .</a>';
$string['flickr'] = 'Enlace a Flickr';
$string['flickrdesc'] = 'Introduzca el enlace (URL) a su página en Flickr.
<a href="http://www.flickr.com" target="_blank"> (www.flickr.com) .</a>';
$string['fotolog'] = 'Enlace a FotoLog';
$string['fotologdesc'] = 'Introduzca el enlace (URL) a su página en FotoLog.
<a href="http://www.fotolog.com/" target="_blank"> (www.fotolog.com) .</a>';
$string['instagram'] = 'Enlace a Instagram';
$string['instagramdesc'] = 'Introduzca el enlace (URL) a su página en Instagram.
<a href="http://instagram.com/" target="_blank"> (instagram.com) .</a>';
$string['panoramio'] = 'Enlace a Panoramio';
$string['panoramiodesc'] = 'Introduzca el enlace (URL) a su página en Panoramio.
<a href="http://www.panoramio.com" target="_blank"> (www.panoramio.com) .</a>';
$string['picasa'] = 'Enlace a Picasa';
$string['picasadesc'] = 'Introduzca el enlace (URL) a su página en Picasa.
<a href="http://picasa.google.com/" target="_blank"> (picasa.google.com) .</a>';
$string['pixabay'] = 'Enlace a PixaBay';
$string['pixabaydesc'] = 'Introduzca el enlace (URL) a su página en PixaBay.
<a href="http://pixabay.com/" target="_blank"> (pixabay.com) .</a>';
$string['photobucket'] = 'Enlace a Photobucket';
$string['photobucketdesc'] = 'Introduzca el enlace (URL) a su página en Photobucket.
<a href="http://www.photobucket.com/" target="_blank"> (www.photobucket.com) .</a>';
/**/
$string['dailymotion'] = 'Enlace a DailyMotion';
$string['dailymotiondesc'] = 'Introduzca el enlace (URL) a su página en DailyMotion.
<a href="http://www.dailymotion.com/" target="_blank"> (www.dailymotion.com) .</a>';
$string['schooltube'] = 'Enlace a SchoolTube';
$string['schooltubedesc'] = 'Introduzca el enlace (URL) a su página en SchoolTube.
<a href="https://www.schooltube.com/" target="_blank"> (www.schooltube.com) .</a>';
$string['videolog'] = 'Enlace a VideoLog';
$string['videologdesc'] = 'Introduzca el enlace (URL) a su página en VideoLog.
<a href="http://videolog.tv/" target="_blank"> (videolog.tv) .</a>';
$string['vimeo'] = 'Enlace a Vimeo';
$string['vimeodesc'] = 'Introduzca el enlace (URL) a su canal en Vimeo.
<a href="http://www.vimeo.com/" target="_blank"> (www.vimeo.com) .</a>';
$string['youtube'] = 'Enlace a YouTube';
$string['youtubedesc'] = 'Introduzca el enlace (URL) a su canal en YouTube.
<a href="http://www.youtube.com/" target="_blank"> (www.youtube.com) .</a>';
/**/
$string['deviantart'] = 'Enlace a DeviantArt';
$string['deviantartdesc'] = 'Introduzca el enlace (URL) a su cuenta en DeviantArt.
<a href="http://www.deviantart.com/" target="_blank"> (www.deviantart.com) .</a>';
$string['myspace'] = 'Enlace a MySpace';
$string['myspacedesc'] = 'Introduzca el enlace (URL) a su perfil en MySpace.
<a href="http://www.myspace.com/" target="_blank"> (www.myspace.com) .</a>';
/**/
$string['socialhead'] = 'Opciones de enlaces a perfiles profesionales';
$string['linkedin'] = 'Enlace a LinkedIn';
$string['linkedindesc'] = 'Introduzca el enlace (URL) a su perfil en LinkedIn.
<a href="http://www.linkedin.com/" target="_blank"> (www.linkedin.com) .</a>';
$string['xing'] = 'Enlace a Xing';
$string['xingdesc'] = 'Introduzca el enlace (URL) a su perfil en Xing.
<a href="http://www.xing.com/" target="_blank"> (www.xing.com) .</a>';
$string['yelp'] = 'Enlace a Yelp';
$string['yelpdesc'] = 'Introduzca el enlace (URL) a su perfil en Yelp.
<a href="http://www.yelp.com/" target="_blank"> (www.yelp.com) .</a>';
/**/
$string['facebook'] = 'Enlace a Facebook';
$string['facebookdesc'] = 'Introduzca el enlace (URL) a su página en Facebook.
<a href="http://www.facebook.com/" target="_blank"> (www.facebook.com) .</a>';
$string['twitter'] = 'Enlace a Twitter';
$string['twitterdesc'] = 'Introduzca el enlace (URL) a su cuenta de Twitter.
<a href="http://twitter.com/" target="_blank"> (twitter.com) .</a>';
$string['vkontakte'] = 'Enlace a VKontakte';
$string['vkontaktedesc'] = 'Introduzca el enlace (URL) de su página en Vkontakte.
<a href="http://www.vk.com/" target="_blank"> (www.vk.com) .</a>';
$string['orkut'] = 'Enlace a Orkut';
$string['orkutdesc'] = 'Introduzca el enlace (URL) a su perfil en Orkut.
<a href="http://www.orkut.com/" target="_blank"> (www.orkut.com) .</a>';
$string['pinterest'] = 'Enlace a Pinterest';
$string['pinterestdesc'] = 'Introduzca el enlace (URL) de su página en Pinterest.
<a href="http://pinterest.com/" target="_blank"> (pinterest.com) .</a>';
/**/
$string['aim'] = 'Enlace a AIM';
$string['aimdesc'] = 'Introduzca el enlace (URL) a su perfil en AIM.
<a href="http://www.aim.com/" target="_blank"> (www.aim.com) .</a>';
$string['googleplus'] = 'Enlace a Google+';
$string['googleplusdesc'] = 'Introduzca el enlace (URL) a su perfil en Google+.
<a href="http://plus.google.com/" target="_blank"> (plus.google.com) .</a>';
$string['microsoftid'] = 'Enlace a Microsoft Live';
$string['microsoftiddesc'] = 'Introduzca el enlace (URL) a su perfil en Microsoft Live.
<a href="http://profile.live.com/" target="_blank"> (profile.live.com) .</a>';
$string['openid'] = 'Enlace a Open ID';
$string['openiddesc'] = 'Introduzca el enlace (URL) a su perfil en Open ID.
<a href="http://openid.net/" target="_blank"> (openid.net) .</a>';
$string['yahooid'] = 'Enlace a Yahoo';
$string['yahooiddesc'] = 'Introduzca el enlace (URL) a su perfil en Yahoo.
<a href="http://profile.yahoo.com/" target="_blank"> (profile.yahoo.com) .</a>';
/**/
$string['tumblr'] = 'Enlace a Tumblr';
$string['tumblrdesc'] = 'Introduzca el enlace (URL) a su blog en Tumblr.
<a href="http://tumblr.com/" target="_blank"> (tumblr.com) .</a>';
$string['blogger'] = 'Enlace a Blogger';
$string['bloggerdesc'] = 'Introduzca el enlace (URL) a su blog en Blogger.
<a href="http://www.blogger.com/" target="_blank"> (www.blogger.com) .</a>';
/**/
$string['social1url'] = 'Dirección URL de una red social';
$string['social1urldesc'] = 'Aquí puede introducir la dirección de una red social o enlace que no se encuentra en el listado.';
$string['social1ico'] = 'Icono para esta red social';
$string['social1icodesc'] = 'Introduzca el nombre del icono de la red social que ha definido anteriormente. <br />
Recuerde copiar una imagen tipo icono de 32x32 con el mismo nombre de este icono en la carpeta theme/aigne/pix/brands/.';
/**/
$string['creditshead'] = 'Opciones de mensajes de crédito y mérito';
$string['moodlecredit'] = 'Créditos a Moodle';
$string['moodlecreditdesc'] = 'Si desea que aparezca en el pié de página un mensaje de agradecimiento y un enlace a la página original de <a href="http://moodle.org/" target="_blank">moodle.org.</a>, active esta opción';
$string['compatcredit'] = 'Compatibilidades';
$string['compatcreditdesc'] = 'Si desea que aparezca en el pié de página una lista con los logotipos de las distintas validaciones conseguidas, active esta opción';
$string['compatnotedesc'] = 'En esta sección puede activar las compatibilidades que ha superado su sitio web. <br />
Queda bajo su entera responsabilidad el seguimiento de normativas locales, observar su cumplimiento y mantener la vigencia de estos parámetros';
$string['compatsocial'] = 'Política social';
$string['compatsocialdesc'] = 'Política social';
$string['csocial_1'] = 'Todo el contenido ha sido verificado para la infancia';
$string['csocial_2'] = 'Se aplican directrices de igualdad de genero';
$string['csocial_3'] = 'Se aplican directrices multi culturales';
$string['compatwai'] = 'Validación de Accesibilidad';
$string['compatwaidesc'] = 'Seleccione el logotipo de accesibilidad que desea mostrar, teniendo en cuenta que usted haya validado su Web, bajo su responsabilidad.
<a href="http://www.w3.org/WAI/WCAG1AAA-Conformance" target="_blank"> (WAI WCAG AAA) .</a>';
$string['compatwai1'] = 'Todavia sin testear';
$string['compatwai2'] = 'Nivel A ';
$string['compatwai3'] = 'Nivel AA ';
$string['compatwai4'] = 'Nivel AAA ';
$string['compattested'] = 'Compatibilidades Validadas';
$string['compattesteddesc'] = 'Seleccione los logotipos que desea mostrar, teniendo en cuenta que usted haya validado su Web, bajo su responsabilidad';
$string['ctested_1'] = 'Validado con WIA CSS <a href="http://jigsaw.w3.org/css-validator/#validate_by_upload" target="_blank"> (WIA CSS) .</a>';
$string['ctested_2'] = 'Validado con WIA HTML 5.0 ó 4.0 <a href="http://validator.w3.org/check?uri=referer" target="_blank"> (WIA HTML 4.0) .</a>';
$string['ctested_3'] = 'Validado con WIA XHTML 1.0 <a href="http://validator.w3.org/check?uri=referer" target="_blank"> (WIA HTML 4.0) .</a>';
$string['ctested_4'] = 'reserved _ Cynthia Validator <a href="http://www.cynthiasays.com/" target="_blank"> (Cynthia) .</a>';
$string['ctested_5'] = 'reserved _ Children Free Validator <a href="http://www.w3.org/WAI/WCAG1AAA-Conformance" target="_blank"> (WAI WCAG AAA) .</a>';
$string['compatbrowser'] = 'Navegadores compatibles';
$string['compatbrowserdesc'] = 'Navegadores compatibles';
$string['browser_1'] = 'Microsoft Internet Explorer';
$string['browser_2'] = 'Firefox (Mozilla)';
$string['browser_3'] = 'Chrome (Webkit)';
$string['browser_4'] = 'Opera (Webkit)';
$string['compatos'] = 'Sistemas Operativos';
$string['compatosdesc'] = 'Sistemas Operativos';
$string['osystem_1'] = 'Windows';
$string['osystem_2'] = 'Linux';
$string['osystem_3'] = 'Mac';
$string['osystem_4'] = 'Android';
$string['osystem_5'] = 'BlackBerry';
$string['compatdevice'] = 'Dispositivos testeados';
$string['compatdevicedesc'] = 'Dispositivos testeados';
$string['device_1'] = 'SmartTV';
$string['device_2'] = 'Ordenador & Estación de trabajo & Servidor';
$string['device_3'] = 'Portátil & Notebook & Netbook';
$string['device_4'] = 'Tablet';
$string['device_5'] = 'Teléfono Móvil & SmartPhone';
$string['footnoteshow'] = 'Mostrar nota al pié';
$string['footnoteshowdesc'] = 'Si desea que aparezca el contenido de la Nota al Pié de Página definido a continuación, active esta opción.';
$string['footnote'] = 'Nota al pié de página';
$string['footnotedesc'] = 'Si desea puede añadir contenido personalizado en el pié de página. Este contenido será insertado a continuación de la zona de créditos.';
/**/
$string['cortesyhead'] = 'Opciones de mensajes de cortesía';
$string['copyrightstg'] = 'Mensaje de Propiedad';
$string['copyrightstgdesc'] = 'Aquí puede escribir el mensaje que aparecerá al final del pié de página, describiendo la propiedad del sitio Web. 
Si deja en blanco esta opción, se compondrá un mensaje con el nombre corto del sitio y el año actual. 
Recuerde que puede usar cualquiera de los modelos internacionalmente reconocidos:<br />
&nbsp;&nbsp;&nbsp; ► COPYRIGHT © AÑO EMPRESA &nbsp;&nbsp;&nbsp; ► EMPRESA © AÑO &nbsp;&nbsp;&nbsp; ► AÑO © EMPRESA';
$string['sitelicensemsg'] = 'Tipo de licencia';
$string['sitelicensemsgdesc'] = 'Si desea que aparezca un mensaje al final del pié de página con el tipo de licencia que rige el contenido de este sitio, active esta opción.<br />
El tipo de licencia se puede configurar en Administración del sitio ► Extensiones ► Licencias ► <a href="settings.php?section=managelicenses">"Administrar licencias"</a> ► "sitedefaultlicense"  . ';
$string['lastmodifiedmsg'] = 'Última actualización';
$string['lastmodifiedmsgdesc'] = 'Si desea que aparezca un mensaje al final del pié de página con la fecha de actualización del sitio web, active esta opción';
$string['thanksvisitmsg'] = 'Mensaje de agradecimiento';
$string['thanksvisitmsgdesc'] = 'Si desea que aparezca un mensaje de agradecimiento al final del pié de página, active esta opción';
/**/
$string['choosereadme'] = '
<div class="clearfix">
  <div class="theme_screenshot">

    <h2>aigne</h2>
    <img src="aigne/pix/screenshot.jpg" />

    <h3>Forum de Divulgación:</h3>
    <p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>

    <h3>Documentación:</h3>
    <p><a href="http://docs.moodle.org/all/es/admin/setting/themesettingaigne">Documentación oficial del tema Aigne</a></p>
  
    <h3>Para informar incidencias:</h3>
    <p>Enviar un eMail a francpombal@hotmail.com</p>
  </div>
 
  <div class="theme_description">
    <h3>Acerca de:</h3>
    <p>Tema para Moodle 2.x y 3.0 _ Principales características:</p>
    <ul>
      <li>Diseño simple, totalmente compatible con CSS y adaptativo a diversos tamaños de pantalla.
      <li>Solo utiliza 5 tonalidades del color principal, también con esquemas predeterminados de color.
      <li>Opciones de @font-face, para elegir entre 3 tipos de letra incluidas.
      <li>Logotipo, lema del sitio y una imagen de fondo del logotipo.
      <li>Nuevas opciones para las etiquetas META del header (herramientas SEO).
      <li>Página principal con zonas para banner, información de marketing o imagenes, totalmente personalizable.
      <li>Area de Información del Usuario, que puede ser mostrada en el encabezado o en el bloque de navegación.
      <li>Sección NavHelp con todos los enlaces administrativos requeridos a páginas personalizables según el idioma
      (mapa web, ayuda, búsqueda, estadísticas, aviso legal, politicas del sitio, privacidad, seguridad y accesibilidad)
      <li>Sección de Contacto, con la adaptación de 30 enlaces a redes sociales y herramientas web.
      <li>Sección de Derechos de propiedad intelectual y Créditos, con opciones para la validación externa en los servidores w3c 
      <br />
      <li>Más de 100 opciones de personalización en Administración del sitio -> Apariencia -> Temas -> AIGNE.
    </ul> 
    <h3>Créditos:</h3>
    <p>Design created by Franc Pombal (www.aigne.com), after improving the AfterBurner Theme in the Moodle core.</p>
    <h3>Licencia:</h3>
    <p>This, and all other themes included in the Moodle core, are licensed under the <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.</p>
  </div>
</div>';
/* END OF FILE */
