<?php 
/**
 * top-of-the-page section _ Moodle adaptation
 * 
 * @package    theme_aigne
 * @copyright  2013-2020 Franc Pombal (www.aigne.com)
 * @license    http://www.gnu.org/copyleft/gpl.html _ GNU GPL v3 or later
 */

If (!empty($PAGE->theme->settings->slogan)) {
    $slogan = $PAGE->theme->settings->slogan;
} 
$hasusernav = $PAGE->theme->settings->usernav;
$haslangmenu = (!empty($PAGE->layout_options['langmenu']));
$hassalut = (!empty($PAGE->theme->settings->usernavsalut));
$haswelsalut = (!empty($PAGE->theme->settings->welcomemsg));
$hasdatemessage = (!empty($PAGE->theme->settings->datemessage));
$datemessagestart =  (!empty($PAGE->theme->settings->datemessagestart));
$datemessagefinis =  (!empty($PAGE->theme->settings->datemessagefinis));
$salut = ''; 

// Set the greeting string
if ($hassalut) {
    if (!isloggedin() or isguestuser()) {
        $salut = '';
    } else {
        $ut = (date('G')*3600 + date('i')*60 + date('s'))/3600;
        if (($ut >=6 ) and ($ut <12 )) {
            $salut =  get_string('morning_greeting', 'theme_aigne');
        } elseif (($ut >=12 ) and ($ut < 18 )) {
            $salut = get_string('afternoon_greeting', 'theme_aigne');
        } else {
            $salut = get_string('night_greeting', 'theme_aigne');              
        }

        if ($haswelsalut) {
            $salut .= ' ';
            $salut .= ($PAGE->theme->settings->welcomemsg);
        //} else if ($hasbirthdate and ($birthdate = $today)) {
           //$salut = $salut & get_string('birthday_greeting', 'theme_aigne');       
        } elseif ($hasdatemessage AND (($datemessagestart <= $today) AND ($datemessagefinis >= $today))) {
            $salut .= ' ';
            $salut .= ($PAGE->theme->settings->datemessage);                                                                                 
        }
    }
}   

?>

<div id="headerlogo">
    <a href="<?php echo $CFG->wwwroot; ?>" title="<?php print_string('home'); ?>">
        <div class="logo"></div>
        <p class="slogan"><?php echo $slogan ?></p>
    </a>
</div>

<div id="headeroptions">
    <table class="headerop">
         <tr Style="height:25px">
            <td class="color_01 rect20" colspan=5>&nbsp;</td>
            <td class="color_02 rect16" colspan=4>&nbsp;</td>
            <td class="color_03 rect16" colspan=4>
                <?php echo ''; ?>
            </td>
            <td class="color_04 rectuser" colspan=12>
            <?php 
            switch ($hasusernav) {
                case 1: //moodle user drop-down menu
                    ?> 
                    <div class="topmessage" style="float: left; margin: 0px 0px -10px 5em; padding: 0.5em 0px 0px 0px; font-size: 0.9em;"><?php  echo $salut; ?></div>
                    <?php                
                    if (method_exists($OUTPUT, 'user_menu')) {                                         
                      echo $OUTPUT->user_menu(); // user menu, for Moodle 2.8
                    } else {
                      echo $OUTPUT->login_info(); // login_info, Moodle 2.7 and before
                    }            
                    break;                     
                case 2: //moodle standard
                    ?> 
                    <div class="topmessage" style="float: left; margin: 0px 0px -10px 5em; padding: 0.5em 0px 0px 0px; font-size: 0.9em;"><?php  echo $salut; ?></div>
                    <?php                
                    echo $OUTPUT->login_info();
                    break;
                case 3: //only salut
                    ?> 
                    <div class="topmessage" style="float: left; margin: 0px 0px -10px 5em; padding: 0.5em 0px 0px 0px; font-size: 0.9em;"><?php  echo $salut; ?></div>
                    <?php
                    break;
                case 4: //none
                    echo '&nbsp;';
                    break;
                default:
                    echo $OUTPUT->login_info();
                    break;
            } ?>
            </td>
        </tr>
        <tr Style="height:25px">
            <td class="color_05 rect08" colspan=2>&nbsp;</td>
            <td class="color_03 rect20" colspan=5>
                <button id="decfontsize" title="<?php echo get_string('decfontsizetxt','theme_aigne'); ?>" onclick="alert('<?php echo get_string('noimplemented','theme_aigne'); ?>')">&nbsp;</button>
                <button id="defaultfontsize" title="<?php echo get_string('defaultfontsizetxt','theme_aigne'); ?>" onclick="alert('<?php echo get_string('noimplemented','theme_aigne'); ?>')">&nbsp;</button>
                <button id="incfontsize" title="<?php echo get_string('incfontsizetxt','theme_aigne'); ?>" onclick="alert('<?php echo get_string('noimplemented','theme_aigne'); ?>')">&nbsp;</button>
            </td>
            <td class="color_05 rect16" colspan=4>&nbsp;</td>
            <td class="rect04" Style="background-color:#CCDDEE" colspan=1>
                <button id="style1" title="<?php echo get_string('defaultstyletxt','theme_aigne'); ?>" onclick="alert('<?php echo get_string('noimplemented','theme_aigne'); ?>')">&nbsp;</button>
            </td>
            <td class="rect04" Style="background-color:#322C65" colspan=1>
                <button id="style2" title="<?php echo get_string('styletxt','theme_aigne'); ?>" onclick="alert('<?php echo get_string('noimplemented','theme_aigne'); ?>')">&nbsp;</button>
            </td>
            <td class="rect04" Style="background-color:#004040" colspan=1>
                <button id="style3" title="<?php echo get_string('styletxt','theme_aigne'); ?>" onclick="alert('<?php echo get_string('noimplemented','theme_aigne'); ?>')">&nbsp;</button>
            </td>
            <td class="rect04" Style="background-color:#EB8324" colspan=1>
                <button id="style4" title="<?php echo get_string('styletxt','theme_aigne'); ?>" onclick="alert('<?php echo get_string('noimplemented','theme_aigne'); ?>')">&nbsp;</button>
            </td>
            <td class="rect04" Style="background-color:#990000" colspan=1>
                <button id="style5" title="<?php echo get_string('styletxt','theme_aigne'); ?>" onclick="alert('<?php echo get_string('noimplemented','theme_aigne'); ?>')">&nbsp;</button>
            </td>
            <td class="color_03 rectlang" colspan=5>
                <?php if ($haslangmenu) {
                    echo $OUTPUT->lang_menu();
                } ?>
            </td>
            <td class="rect16" colspan=4>&nbsp;</td>
        </tr>
    </table>
<?php echo $OUTPUT->page_heading_menu(); ?>
</div>

